<?php
$baseDir = __DIR__;
$fixed = [];
$failed = [];
function fixPermissions($dir, &$fixed, &$failed) {
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::SELF_FIRST
    );
    foreach ($iterator as $item) {
        $path = $item->getPathname();
        
        // Skip assets/blueimp folder
        $normalizedPath = str_replace('\\', '/', $path);
        if (strpos($normalizedPath, 'assets/blueimp') !== false) {
            continue;
        }
        
        if (!is_writable($path)) {
            if ($item->isDir()) {
                $success = @chmod($path, 0755);
            } else {
                $success = @chmod($path, 0644);
            }
            if ($success && is_writable($path)) {
                $fixed[] = $path;
            } else {
                $failed[] = $path;
            }
        }
    }
    // check the root folder too
    if (!is_writable($dir)) {
        $success = @chmod($dir, 0755);
        if ($success && is_writable($dir)) {
            $fixed[] = $dir;
        } else {
            $failed[] = $dir;
        }
    }
}
fixPermissions($baseDir, $fixed, $failed);
if (!empty($fixed)) {
    return true;
}
if (!empty($failed)) {
    return false;
}
?>